<?php
// STATIC CLASS CONTAINING METHODS IMPLEMENTING AND EXECUTING PASSWORD RECOVERY SYSTEM

class pcma_psw_recovery {
    

    // ADD RECOVERY PSW BUTTON'S ICON into settings 
    public static function pr_btn_opt($structure) {
        $structure['styling']['button_icons']['fields']['pcma_pr_btn_icon'] = array(
            'type'		=> 'custom',
            'callback'	=> 'pcma_psw_recovery::pr_btn_icon_field',
            'validation'=> array(
                array('index' => 'pcma_rp_btn_icon', 'label' => "Mail Actions add-on - Psw recovery button's icon"),
            )
        );
        return $structure;
    }
    
    // ADD RECOVERY PSW BUTTON'S ICON into settings - callback
    public static function pr_btn_icon_field($field_id, $field, $value, $all_vals) {
        $icon = get_option($field_id);
        ?>
        <tr class="pc_<?php echo $field_id ?>_tr">
            <td class="lcwp_sf_label">
                <label>Mail Actions add-on - <?php _e("Password recovery button's icon", PCMA_ML) ?></label>
            </td>
            <td class="lcwp_sf_field">

                <div class="pc_field_icon_trigger">
                    <i class="<?php echo esc_attr( pc_static::fontawesome_v4_retrocomp($icon)) ?>" title="<?php esc_attr_e('set icon', PCMA_ML) ?>"></i>
                    <input type="hidden" name="<?php echo $field_id ?>" value="<?php echo esc_attr( pc_static::fontawesome_v4_retrocomp($icon)) ?>" /> 
                </div>
            </td>
        </tr>
        <?php
    }
    
    
    
    
    
    // password recovery trigger
    public static function psw_recovery_trigger($form) {
        if(pcma_is_active() && get_option('pcma_psw_recovery')) {
            $code = '<small class="pcma_psw_recovery_trigger">'. __('forgot password?', PCMA_ML) .'</small>';
            return $form . $code;
        }
        else {
            return $form;
        }
    }
    
    
    
    
    
    // login form class
    public static function psw_recovery_lf_class($classes) {
        if(pcma_is_active() && get_option('pcma_psw_recovery')) {
            $classes[] = 'has_pcma_psw_recovery'; 
        }
        
        return $classes;
    }
    
    
    
    
    
    // password recovery code
    public static function psw_recovery_code($form) {
        if(!pcma_is_active() || !get_option('pcma_psw_recovery')) {
            return $form;    
        }

        $label = (get_option('pcma_pr_with_email')) ? __('Insert your username or e-mail', PCMA_ML) : __('Insert your username', PCMA_ML); 

        // fields icon
        $pr_icon_class 	= (get_option('pcma_rp_field_icon')) ? 'pc_field_w_icon' : '';
        $pr_icon 		= ($pr_icon_class) ? '<span class="pc_field_icon" title="'. esc_attr($label) .'"><i class="'. esc_attr( pc_static::fontawesome_v4_retrocomp(get_option('pcma_rp_field_icon')) ) .'"></i></span>' : '';

        // button's icon
        $icon = (get_option('pcma_rp_btn_icon')) ? '<i class="'. esc_attr( pc_static::fontawesome_v4_retrocomp(get_option('pcma_rp_btn_icon')) ) .'"></i>' : '';

        // placeholders only if no-label is active
        $placeh = (get_option('pg_nolabel')) ? 'placeholder="'. esc_attr($label) .'"' : ''; 

        $code = '
        <div class="pcma_psw_recovery_wrap pc_displaynone">
            <div class="pc_login_row '.$pr_icon_class.'">
                <label>'. $label .'</label>

                <div class="pc_field_container">
                    '. $pr_icon .'
                    <input type="text" name="pcma_psw_username" class="pcma_psw_username" value="" '. $placeh .' autocomplete="off" />
                </div>
            </div>
            
            <div class="pc_lf_subfields">
                <div class="pc_login_smalls">
                    <small class="pcma_del_recovery">'. __('Back to login form', PCMA_ML) .'</small>
                </div>
                <div class="pcma_psw_recovery_message"></div>
            </div>
            
            <button class="pcma_do_recovery" type="button">
                <span class="pc_inner_btn">'. $icon . __('Recover', PCMA_ML) .'</span>
            </button>
        </div>';

        return $form . $code;
    }
    
    
    
    
    
    // custom CSS for recovery psw form
    public static function psw_recovery_css() {
        if(!pcma_is_active() || !get_option('pcma_psw_recovery')) {
            return true;
        }
        ?>
        /* Mail actions add-on - password recovery */
        .pcma_psw_recovery_trigger,
        .pcma_del_recovery {
            cursor: pointer;
            transition: all .2s ease;
        }
        .pcma_psw_recovery_trigger:hover,
        .pcma_del_recovery:hover {
            opacity: 0.7 !important;
        }
        .has_pcma_psw_recovery:not(.pc_rm_login):not(.pc_fullw_login_btns) .pc_lf_subfields {
            flex-direction: column-reverse;
        }
        .has_pcma_psw_recovery:not(.pc_rm_login):not(.pc_fullw_login_btns) .pc_login_smalls {
            justify-content: end;
            margin: 0 0 -27px;
        }
        .pcma_psw_recovery_message {
            margin: 15px 0 <?php echo get_option('pg_login_fields_gap') ?>px;
            min-height: 0.1px;
        }
        .pcma_psw_recovery_message .pc_success_mess {
            margin-bottom: -19px;
        }
        .pc_fullw_login_btns .pcma_psw_recovery_message:empty {
            margin-top: 0;
        }
        .pc_login_form:not(.pc_fullw_login_btns) .pcma_psw_recovery_wrap .pc_login_smalls {
            min-height: 1.2em;
        }
        <?php
    }
    
    
    
    
    // set e-mail field as required if psw recovery with mail is active
    public static function set_mail_sys_req($bool) {

        if(pcma_is_active()) {
            if(get_option('pcma_psw_recovery') && get_option('pcma_pr_with_email')) {
                return true;
            }
        }

        return $bool;
    }
    
    
    
    
    
    // perform password recovery - front ajax
    public static function do_psw_recovery() {
        global $wpdb, $pc_users, $pc_meta;
        
        $username = (isset($_POST['pcma_psw_username'])) ? trim($_POST['pcma_psw_username']) : false;
        $anti_bruteforce_block = 0;
        
        // anti-bruteforce - is IP already blacklisted?
        if(pc_abfa_static::visitor_is_blacklisted()) {
            wp_die(json_encode(array( 
                'resp' => 'error',
                'mess' => pc_abfa_static::error_message(),
                'abfa' => $anti_bruteforce_block,
            )));   
        }
        
        include_once(PC_DIR .'/classes/pc_form_framework.php');
        $f_fw = new pc_form();
        
        // antispam
        $antispam_sys = get_option('pg_antispam_sys', 'honeypot');
        if($antispam_sys == 'honeypot') {
            if(!$f_fw->honeypot_validaton()) {
                wp_die(json_encode(array( 
                    'resp' => 'error',
                    'mess' => "Bot test not passed",
                    'abfa' => $anti_bruteforce_block,
                )));
            }
        }
        else {
            // check user token
            if(!isset($_POST['grecaptcha_token']) || empty($_POST['grecaptcha_token'])) {
                wp_die(json_encode(array( 
                    'resp' => 'error',
                    'mess' => "reCAPTCHA - missing user token!",
                    'abfa' => $anti_bruteforce_block,
                )));
            }
            else {

                // get google's answer
                $response = wp_remote_post('https://www.google.com/recaptcha/api/siteverify', array(
                    'method' => 'POST',
                    'body' => array(
                        'secret' 	=> get_option('pg_recaptcha_secret'), 
                        'response' 	=> $_POST['grecaptcha_token'],
                        'abfa' => $anti_bruteforce_block,
                    ),
                ));	

                if(is_wp_error($response) || wp_remote_retrieve_response_code($response) != 200) {
                    wp_die(json_encode(array( 
                        'resp' => 'error',
                        'mess' => "reCAPTCHA - ". strip_html__("error retrieving remote check", PC_ML),
                        'abfa' => $anti_bruteforce_block,
                    )));	
                } 
                else {
                    $body = json_decode(wp_remote_retrieve_body($response), true);

                    if(
                        !is_array($body) || !isset($body['success']) || !$body['success'] ||
                        ($antispam_sys == 'recaptcha' && (float)$body['score'] < 0.4)
                    ) {
                        wp_die(json_encode(array( 
                            'resp' => 'error',
                            'mess' => "reCAPTCHA - ". __("bot detected", PC_ML) .' '. $body['score'],
                            'abfa' => $anti_bruteforce_block,
                        )));	  
                    }
                }
            }
        }
        
        
        if(empty($username)) {
            $error = __('Please insert a value', PCMA_ML);
            $anti_bruteforce_block = pc_abfa_static::add_to_blacklist();
        }
        else {
            // only username or also e-mail?
            $username_part = (get_option('pcma_pr_with_email')) ? '(username = %s OR email = %s)' : 'username = %s';
            $wpdb_prepare_vars = (get_option('pcma_pr_with_email')) ? array($username, $username) : array($username);

            $user_data = $wpdb->get_row( 
                $wpdb->prepare(
                    "SELECT * FROM  ".PC_USERS_TABLE." WHERE ". $username_part ." AND status = 1 LIMIT 1",
                    $wpdb_prepare_vars
                ) 
            , ARRAY_A);

            if(empty($user_data)) {
                $error = __('Username not found or disabled', PCMA_ML);
            }
            else {
                if(empty($user_data['email'])) {
                    $error = __("Your account doesn't have an e-mail", PCMA_ML);	
                }
                else {
                    $mail_txt = get_option('pcma_psw_mail_txt');

                    // reset password
                    ///// be sure psw matches with strength params
                    $new_psw = $f_fw->generate_psw();

                    // replace placeholder
                    $mail_txt = str_replace('%PSW%', $new_psw, $mail_txt);

                    // update user psw
                    $result = $pc_users->update_user($user_data['id'], array('psw' => $new_psw));
                    if(!$result) {
                        $error = __("Error updating password in database", PCMA_ML);		
                    }

                    // perform only if there are no errors
                    if(!isset($error)) {
                        $mail_title = pcma_replace_placeholders($user_data['id'], get_option('pcma_psw_mail_subj'), $user_data);

                        $mail_txt = pcma_apply_mail_templates(get_option('pcma_psw_mail_template'), $mail_txt);
                        $mail_txt = pcma_replace_placeholders($user_data['id'], $mail_txt, $user_data);

                        // send mail
                        $mail_sent = pcma_send_mail($user_data['username'], $user_data['email'], $mail_title, $mail_txt);
                        if(!$mail_sent) {
                            $error = __("Error sending the e-mail", PCMA_ML);
                        }
                    }
                }
            }	
        }

        // errors?
        if(isset($error)) {
            wp_die(json_encode(array(
                'resp' => 'error', 
                'mess' => $error,
                'abfa' => $anti_bruteforce_block,
            )));
        }

        // safe mode? set timestamp for expiration
        if(get_option('pcma_safe_psw_recovery', true) && defined('PCUD_DIR')) {
            $timestamp = current_time('timestamp', true);
            $pc_meta->update_meta($user_data['id'], 'pcma_psw_recovery_time', $timestamp);   
            $pc_meta->update_meta($user_data['id'], 'pcud_forced_psw_reset', wp_generate_password(8, false));   
        }

        // PCMA ACTION - USER PASSWORD HAS BEEN RESETTED
        do_action('pcma_resetted_psw', $user_data['id']);

        wp_die(json_encode(array(
            'resp' => 'success', 
            'mess' => __("A new password has been sent to your e-mail address", PCMA_ML)
        )));
    }
    
    
    
    
    // safe mode - check password expiration on user login 
    public static function safe_mode_login_check($cust_mess, $user_id) {
        global $pc_meta;

        // if there's already a message - return it
        if(!empty($cust_mess)) {
            return $cust_mess;
        }

        $psw_recovery_time = (int)$pc_meta->get_meta($user_id, 'pcma_safe_psw_recovery');  
        
        if(get_option('pcma_safe_psw_recovery', true) && defined('PCUD_DIR') && $psw_recovery_time) {
            $now = current_time('timestamp', true);
            $time_limit = 60 * 60 * 20; // 20 minutes before expiration
            
            if($now - $psw_recovery_time > $time_limit) {
                return __("Your temporary password expired, please recover it again", PCMA_ML);            
            }
            
            $pc_meta->delete_meta($user_id, 'pcma_safe_psw_recovery');
        }
         
        // fallback
        return $cust_mess;
    }
}



add_filter('pc_settings_structure', 'pcma_psw_recovery::pr_btn_opt'); // ADD RECOVERY PSW BUTTON'S ICON into settings
add_filter('pcma_psw_recovery_trigger', 'pcma_psw_recovery::psw_recovery_trigger'); // password recovery trigger
add_filter('pc_login_form_classes', 'pcma_psw_recovery::psw_recovery_lf_class'); // add specific class to login form
add_filter('pcma_psw_recovery_code', 'pcma_psw_recovery::psw_recovery_code'); // password recovery code
add_action('pc_custom_style_css', 'pcma_psw_recovery::psw_recovery_css'); // custom CSS for recovery psw form
add_filter('pc_set_mail_required', 'pcma_psw_recovery::set_mail_sys_req', 999, 2); // set e-mail field as required if psw recovery with mail is active
add_filter('pc_login_custom_check', 'pcma_psw_recovery::safe_mode_login_check', 100, 2); // safe mode - check password expiration on user login

add_action('wp_ajax_pcma_do_psw_recovery', 'pcma_psw_recovery::do_psw_recovery'); // perform password recovery - front ajax
add_action('wp_ajax_nopriv_pcma_do_psw_recovery', 'pcma_psw_recovery::do_psw_recovery');
